--[[

██╗  ██╗███████╗██████╗ ██╗  ██╗ █████╗     ██╗    ██╗ █████╗ ███████╗    ██╗  ██╗███████╗██████╗ ███████╗
██║  ██║██╔════╝██╔══██╗██║  ██║██╔══██╗    ██║    ██║██╔══██╗██╔════╝    ██║  ██║██╔════╝██╔══██╗██╔════╝
███████║█████╗  ██████╔╝███████║███████║    ██║ █╗ ██║███████║███████╗    ███████║█████╗  ██████╔╝█████╗  
██╔══██║██╔══╝  ██╔═══╝ ██╔══██║██╔══██║    ██║███╗██║██╔══██║╚════██║    ██╔══██║██╔══╝  ██╔══██╗██╔══╝  
██║  ██║███████╗██║     ██║  ██║██║  ██║    ╚███╔███╔╝██║  ██║███████║    ██║  ██║███████╗██║  ██║███████╗
╚═╝  ╚═╝╚══════╝╚═╝     ╚═╝  ╚═╝╚═╝  ╚═╝     ╚══╝╚══╝ ╚═╝  ╚═╝╚══════╝    ╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝╚══════╝
                                                                                                          
    Feel free to contact me for any questions or commisions!
    https://steamcommunity.com/profiles/76561198242379576/myworkshopfiles/
    https://ko-fi.com/hepha
    Discord: hephaisto1                                                                                                          
	
	SCP Custom Outfit Weapon Defintions for each Outfit Class
]]

require "Definitions/AttachedWeaponDefinitions"

AttachedWeaponDefinitions.meleeInBack_Mid_SCP = {
	id = "meleeInBack_Mid_SCP",
	chance = 100,
	outfit = {"SCP_DClass_Survivor"},
	weaponLocation = {"Big Weapon On Back"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	weapons = {
	    -- "everyday item" weapons
		"Base.Axe",
		"Base.BaseballBat",
		"Base.BaseballBat_Metal",
		"Base.BoltCutters",
		"Base.Crowbar",
		"Base.FireplacePoker",
		"Base.IronBar",
		"Base.LargeBranch",
		"Base.LongHandle",
		"Base.Machete",
		"Base.MetalBar",
		"Base.PickAxe",
		"Base.SteelBar",
		"Base.TireIron",
		"Base.WoodAxe",

		-- more outre weapons
		"Base.AxeStone",
		"Base.BaseballBat_Nails",
		"Base.JawboneBovide",
		"Base.LongHandle_Nails",
		"Base.MetalPipe_Railspike",
		"Base.SpearCraftedFireHardened",
		"Base.SpearGlass",
		"Base.TableLeg",
		"Base.TreeBranch_Nails",
		"Base.BaseballBat_Broken_Nails",
		"Base.Handle_Nails",
		"Base.Branch_Broken_Nails",
		"Base.LongHandle_Broken_Nails",
		"Base.ShortBat_Nails",
		"Base.ShortBat_RakeHead",

		"Base.FieldHockeyStick_Broken",
		"Base.FieldHockeyStick_Broken_Nails",
		"Base.FieldHockeyStick_Nails",
		"Base.IceHockeyStick_BarbedWire",

		"Base.AssaultRifle",
		"Base.AssaultRifle2",
		"Base.DoubleBarrelShotgun",
		"Base.DoubleBarrelShotgunSawnoff",
		"Base.HuntingRifle",
		"Base.Shotgun",
		"Base.ShotgunSawnoff",
	},
}

AttachedWeaponDefinitions.firearm_SCP = {
	id = "firearm_SCP",
	chance = 100,
	outfit = {"SCP_Guard"},
	weaponLocation = {"Rifle On Back"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	weapons = {
		"Base.AssaultRifle",
		"Base.Shotgun",
		"Base.SCP_P90",
	},
}

AttachedWeaponDefinitions.firearm_SCP_P90 = {
	id = "firearm_SCP",
	chance = 100,
	outfit = {"SCP_Guard"},
	weaponLocation = {"Rifle On Back"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	weapons = {
		"Base.SCP_P90",
	},
}

AttachedWeaponDefinitions.firearm_SCP_Ranger = {
	id = "firearm_SCP_Ranger",
	chance = 100,
	outfit = {"SCP_MTF_Ranger"},
	weaponLocation = {"Rifle On Back with Bag"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	weapons = {
		"Base.SCP_P90",
		"Base.AssaultRifle2",
	},
}

AttachedWeaponDefinitions.firearm_SCP_Breacher = {
	id = "firearm_SCP_Breacher",
	chance = 100,
	outfit = {"SCP_MTF_Breacher"},
	weaponLocation = {"Rifle On Back"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	weapons = {
		"Base.SCP_P90",		
		"Base.SCP_P90",		
		"Base.AssaultRifle",
	},
}

AttachedWeaponDefinitions.handgunHolster_SCP = {
	id = "handgunHolster_SCP",
	chance = 50,
	outfit = {"SCP_Guard","SCP_DClass_Survivor", "SCP_MTF_Ranger", "SCP_MTF_Breacher"},
	weaponLocation =  {"Holster Right"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	ensureItem = "Base.HolsterSimple",
	weapons = {
		"Base.Pistol",
		"Base.Pistol2",
		"Base.Pistol3",
		"Base.Revolver",
		"Base.Revolver_Long",
		"Base.Revolver_Short",
	},
}

AttachedWeaponDefinitions.handgunHolsterShoulder_SCP = {
	id = "handgunHolsterShoulder_SCP",
	chance = 50,
	outfit = {"SCP_DClass_Survivor"},
	weaponLocation =  {"Holster Shoulder"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	ensureItem = "Base.HolsterShoulder",
	weapons = {
		"Base.Pistol",
		"Base.Pistol2",
		"Base.Pistol3",
		"Base.Revolver",
		"Base.Revolver_Long",
		"Base.Revolver_Short",
	},
}
AttachedWeaponDefinitions.knivesBelt_SCP = {
	id = "knivesBelt_SCP",
	chance = 100,
	outfit = {"SCP_MTF_Ranger", "SCP_MTF_Breacher"},
	weaponLocation = {"Belt Left Upside"},
	bloodLocations = nil,
	addHoles = false,
	daySurvived = 0,
	ensureItem = "Base.Belt2",
	weapons = {
		"Base.SCP_Mtf_tactical_machete",
	},
}


AttachedWeaponDefinitions.attachedWeaponCustomOutfit.SCP_DClass_Survivor = {
	chance = 100;
	maxitem = 2;
	weapons = {
		AttachedWeaponDefinitions.meleeInBack_Mid_SCP,
		AttachedWeaponDefinitions.handgunHolster_SCP,
		AttachedWeaponDefinitions.handgunHolsterShoulder_SCP,
	},
}

AttachedWeaponDefinitions.attachedWeaponCustomOutfit.SCP_Guard = {
	chance = 60;
	maxitem = 2;
	weapons = {
		AttachedWeaponDefinitions.firearm_SCP,
		AttachedWeaponDefinitions.firearm_SCP_P90,
		AttachedWeaponDefinitions.handgunHolster_SCP,
	},
}

AttachedWeaponDefinitions.attachedWeaponCustomOutfit.SCP_MTF_Ranger = {
	chance = 100;
	maxitem = 3;
	weapons = {
		AttachedWeaponDefinitions.firearm_SCP_Ranger,
		AttachedWeaponDefinitions.handgunHolster_SCP,
		AttachedWeaponDefinitions.knivesBelt_SCP,
	},
}
AttachedWeaponDefinitions.attachedWeaponCustomOutfit.SCP_MTF_Breacher = {
	chance = 100;
	maxitem = 3;
	weapons = {
		AttachedWeaponDefinitions.firearm_SCP_Breacher,
		AttachedWeaponDefinitions.handgunHolster_SCP,
		AttachedWeaponDefinitions.knivesBelt_SCP,
	},
}